/*
* Copyright 2012-2014 Marc Schoolderman
*
* Licensed under the EUPL, Version 1.1 or – as soon they
will be approved by the European Commission - subsequent
versions of the EUPL (the "Licence");
* You may not use this work except in compliance with the
Licence.
* You may obtain a copy of the Licence at:
*
* http://ec.europa.eu/idabc/eupl5
*
* Unless required by applicable law or agreed to in
writing, software distributed under the Licence is
distributed on an "AS IS" basis,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
express or implied.
* See the Licence for the specific language governing
permissions and limitations under the Licence.
*/

definition module StdImperative

from StdOverloaded import class toInt(toInt), class toString(toString)
from WrapEnv import ::Output 

:: Code 
:: WeakValue
:: Assignation :== Code -> WeakValue
:: Var :== Var_ Code
:: Element i = A i|B i|C i|D i|E i|F i|G i|H i|I i|J i|K i|L i|M i|N i|O i|P i|Q i|R i|S i|T i|U i|V i|W i|X i|Y i|Z i
:: Var_ i :== i->Element i

run :: a -> Output String | yield a
labels :: a -> [String] | $a

instance toInt Code 
instance toString Code

class $ a :: a -> Code 
instance $ Code
instance $ WeakValue
instance $ (Code->a) | $a
instance $ Int 
instance $ (Element i) | $i
instance $ (Var_ i)
instance $ [a] | yield a
instance $ Interval
instance $ Char 
instance $ String

(`) infixr 0 :: a b -> Code | yield a & yield b

size :: a -> Code | $a
(elem) infix 9 :: a b -> Code | $a & $b

(==) infix 5 :: a b -> Code | $a & $b
(<>) infix 5 :: a b -> Code | $a & $b
(<)  infix 5 :: a b -> Code | $a & $b
(<=) infix 5 :: a b -> Code | $a & $b
(>)  infix 5 :: a b -> Code | $a & $b
(>=) infix 5 :: a b -> Code | $a & $b
(between) infixr 5 :: a (b,c) -> Code | $a & $b & $c

(+)  infixl 6 :: a b -> Code | $a & $b
(-)  infixl 6 :: a b -> Code | $a & $b
(*)  infixl 7 :: a b -> Code | $a & $b
(/)  infixl 7 :: a b -> Code | $a & $b
(mod) infix 7 :: a b -> Code | $a & $b

(and) infixl 4 :: a b -> Code | $a & $b
(or) infixl 4 :: a b -> Code | $a & $b
not :: a -> Code | $a

(||)  infixl 8 :: a b -> Code | $a & $b
(||:=) infixr 3 :: (Var_ i) a -> Assignation | $a

class (local) infixr 0 a :: a b -> Code | $b
instance local (Var_ i)
instance local [Var_ i] 

class (:=) infixr 3 v a :: v a -> Assignation
instance := (Var_ i) a | $a 
instance := (Element i) a | $a & $i
instance := [Var_ i] a | $a 

(+:=) infixr 3 :: (Var_ i) a -> Assignation | $a
(-:=) infixr 3 :: (Var_ i) a -> Assignation | $a
(*:=) infixr 3 :: (Var_ i) a -> Assignation | $a
(/:=) infixr 3 :: (Var_ i) a -> Assignation | $a

(<-|) infixr 3 :: v a -> Assignation | := v a
(|->) infixl 3 :: a v -> Assignation | := v a

pass :: Code

when :: a Code Code -> Code | $a
(do) infixr 2 :: (Code->b) a -> b | yield a
(else) infixl 1 :: (Code->b) a -> b | $a

while :: a b -> Code | $a & yield b
repeat :: a -> a | $a
(until) infixl 1 :: a b -> Code | yield a & $b
break :: Code
continue :: Code

:: LoopVar
:: Interval
for :: Var -> LoopVar
instance := LoopVar Interval // optimized 
instance := LoopVar a | $a
(to) infixr 3 :: a b -> Interval | $a & $b

(@) infixr 0 :: lbl a -> Code | $a & $lbl
goto :: a -> Code | $a
return :: a -> Code | $a

:: Macro 
.\ :: a -> Macro | yield a
instance := (Var_ i) Macro
call :: Var -> Code

putstr :: a -> Code | $a
putint :: a -> Code | $a
print :: a -> Code | $a
println :: a -> Code | $a
(<<) infixl 2 :: (Code->Code) b -> (Code->Code) | $b

str :: a -> Code | $a
int :: a -> Code | $a

class yield a | yield_ Int a
class yield_ x a :: x a -> Code 
instance yield_ Int Assignation
instance yield_ Int a | $a 

cout :== println
endl :== ""
